<?php $__env->startSection('page-title', __('Fee Received')); ?>

<?php $__env->startSection('action-button'); ?>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create feereceived')): ?>

        <div class="text-sm-end d-flex all-button-box justify-content-sm-end">
            <a href="<?php echo e(route('feereceive.export')); ?>" class="btn btn-sm btn-primary mx-1" data-bs-toggle="tooltip"
                data-title=" <?php echo e(__('Export')); ?>" title="<?php echo e(__('Export')); ?>">
                <i class="ti ti-file-export"></i>
            </a>
            <a href="#" class="btn btn-sm btn-primary mx-1" data-ajax-popup="true" data-size="md" data-title="Add Fee Received"
                data-url="<?php echo e(route('fee-receive.create')); ?>" data-toggle="tooltip" title="<?php echo e(__('Create New Fee Received')); ?>" data-bs-original-title="<?php echo e(__('Create New Fee Received')); ?>" data-bs-placement="top" data-bs-toggle="tooltip">
                <i class="ti ti-plus"></i>
            </a>
        </div>
    <?php endif; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><?php echo e(__('Fee Received')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row p-0">
    <div class="col-xl-12">
        <div class="card shadow-none">
            <div class=" card-body table-border-style">
                <h5></h5>
                <div class="table-responsive">
                    <table class="table dataTable data-table">
                        <thead> 
                            <tr>
                                <th><?php echo e(__('Case')); ?></th>
                                <th><?php echo e(__('Date')); ?></th>
                                <th><?php echo e(__('Particulars')); ?></th>
                                <th><?php echo e(__('Fee Received ')); ?></th>
                                <th><?php echo e(__('Payment Method')); ?></th>
                                <th><?php echo e(__('Team Member')); ?></th>
                                <th width="100px"><?php echo e(__('Action')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $fees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <a href="#" class="btn btn-sm" data-url="<?php echo e(route('fee-receive.show', $expense->id)); ?>" data-size="md"
                                    data-ajax-popup="true" data-title="<?php echo e(__(" View Fee")); ?>">
                                    <?php echo e(App\Models\Cases::getCasesById($expense->case)); ?>

                                    </a>
                                </td>

                                <td><?php echo e($expense->date); ?></td>
                                <td><?php echo e($expense->particulars); ?></td>
                                <td><?php echo e($expense->money); ?></td>
                                <td><?php echo e($expense->method); ?></td>
                                <td><?php echo e(App\Models\User::getTeams($expense->member)); ?></td>
                                <td>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view feereceived')): ?>
                                        <div class="action-btn bg-light-secondary ms-2">
                                            <a href="#" class="mx-3 btn btn-sm d-inline-flex align-items-center "
                                                data-url="<?php echo e(route('fee-receive.show', $expense->id)); ?>" data-size="md"
                                                data-ajax-popup="true" data-title="<?php echo e(__(" View Fee")); ?>"
                                                title="<?php echo e(__('View Fee')); ?>" data-bs-toggle="tooltip"
                                                data-bs-placement="top">
                                                <i class="ti ti-eye "></i>
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit feereceived')): ?>
                                        <div class="action-btn bg-light-secondary ms-2">
                                            <a href="#" class="mx-3 btn btn-sm d-inline-flex align-items-center "
                                                data-url="<?php echo e(route('fee-receive.edit', $expense->id)); ?>" data-size="md"
                                                data-ajax-popup="true" data-title="<?php echo e(__('Edit Fee')); ?>"
                                                title="<?php echo e(__('Edit ')); ?>" data-bs-toggle="tooltip"
                                                data-bs-placement="top">
                                                <i class="ti ti-edit "></i>
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete feereceived')): ?>
                                        <div class="action-btn bg-light-secondary ms-2">
                                            <a href="#"
                                                class="mx-3 btn btn-sm d-inline-flex align-items-center bs-pass-para"
                                                data-confirm="<?php echo e(__('Are You Sure?')); ?>"
                                                data-text="<?php echo e(__('This action can not be undone. Do you want to continue?')); ?>"
                                                data-confirm-yes="delete-form-<?php echo e($expense->id); ?>" title="<?php echo e(__('Delete')); ?>"
                                                data-bs-toggle="tooltip" data-bs-placement="top">
                                                <i class="ti ti-trash"></i>
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                    <?php echo Form::open([
                                        'method' => 'DELETE',
                                        'route' => ['fee-receive.destroy', $expense->id],
                                        'id' => 'delete-form-' . $expense->id,
                                        ]); ?>

                                    <?php echo Form::close(); ?>

                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lcms/public_html/resources/views/fee-receive/index.blade.php ENDPATH**/ ?>