<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;

class XSS
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    use \RachidLaasri\LaravelInstaller\Helpers\MigrationsHelper;

   public function handle(Request $request, Closure $next)
{
    if (Auth::check()) {
        // Set the application's locale to the authenticated user's language
        $userLang = Auth::user()->lang;
        \App::setLocale($userLang);
    }

    // Optionally, merge any request inputs (if necessary)
    $input = $request->all();
    $request->merge($input);

    // Continue processing the request
    return $next($request);
}

}
